//
//  AppDelegate_Communcation.m
//  Kyopon Schedule Sync
//
//  Created by FUJIDANA on 06/09/18.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import "AppDelegate.h"
#import "WXKSchedule.h"
#import "WXKProgressWindowController.h"
#import "WXKPasswordWindowController.h"
#import "WXKPhone.h"


@implementation AppDelegate (Communcation)

- (IBAction)send:(id)sender
{
	id passwordController = [WXKPasswordWindowController sharedWindowController];
	NSString *password = [passwordController password];
	if (password == nil) {
		if ([passwordController runModal] == NSAlertFirstButtonReturn) {
			password = [passwordController password];
		} else {
			return;
		}
	}
	
	id progressController = [[[WXKProgressWindowController alloc] initWithParentWindow:window] autorelease];
	WXKPhone *phone = [[[WXKPhone alloc] init] autorelease];
	
	NSArray       *schedules          = [arrayController content];
	NSEnumerator  *scheduleEnumerator = [schedules objectEnumerator];
	NSMutableArray *dataArray         = [NSMutableArray arrayWithCapacity:[schedules count]];
	WXKSchedule   *schedule;
	
	while (schedule = [scheduleEnumerator nextObject]) {
		[dataArray addObject:[schedule vCalendarRepresentation]];
	}
	
	NSError *error;
	if ([phone writeAllItemsOfDataType:WXKPhoneScheduleDataType
							 dataArray:dataArray
						  withPassword:password
							  progress:progressController
								 error:&error] == NO) {
		[NSApp presentError:error];
	}
}

@end
